<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generator Proces Verbal - Zapp</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
            font-weight: 300;
        }
        
        .header p {
            font-size: 1.1em;
            opacity: 0.9;
        }
        
        .form-container {
            padding: 40px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
            font-size: 1.1em;
        }
        
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 15px;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            font-size: 1em;
            transition: border-color 0.3s ease;
        }
        
        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 40px;
            border: none;
            border-radius: 8px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            width: 100%;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .logo {
            max-width: 100px;
            margin-bottom: 20px;
        }
        
        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
            
            .header h1 {
                font-size: 2em;
            }
            
            .form-container {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="assets/logo.png" alt="Zapp Logo" class="logo">
            <h1>Generator Proces Verbal</h1>
            <p>Completează datele pentru a genera procesul verbal</p>
        </div>
        
        <div class="form-container">
            <form action="generate.php" method="POST">
                <div class="form-row">
                    <div class="form-group">
                        <label for="data">Data:</label>
                        <input type="date" id="data" name="data" required>
                    </div>
                    <div class="form-group">
                        <label for="ora">Ora:</label>
                        <input type="time" id="ora" name="ora" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="locul">Locul:</label>
                        <input type="text" id="locul" name="locul" placeholder="ex: București, România" required>
                    </div>
                    <div class="form-group">
                        <label for="tipul_procesului">Tipul procesului:</label>
                        <select id="tipul_procesului" name="tipul_procesului" required>
                            <option value="">Selectează tipul</option>
                            <option value="inventar">Inventar</option>
                            <option value="control">Control</option>
                            <option value="audit">Audit</option>
                            <option value="inspecție">Inspecție</option>
                            <option value="altul">Altul</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="obiectul">Obiectul procesului verbal:</label>
                    <input type="text" id="obiectul" name="obiectul" placeholder="ex: Inventarul bunurilor din depozit" required>
                </div>
                
                <div class="form-group">
                    <label for="participanti">Participanți:</label>
                    <textarea id="participanti" name="participanti" placeholder="Lista participanților cu funcțiile lor" required></textarea>
                </div>
                
                <div class="form-group">
                    <label for="concluzii">Concluzii și observații:</label>
                    <textarea id="concluzii" name="concluzii" placeholder="Concluziile procesului verbal" required></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="semnatar1_nume">Numele primului semnatar:</label>
                        <input type="text" id="semnatar1_nume" name="semnatar1_nume" placeholder="ex: Popescu Ion" required>
                    </div>
                    <div class="form-group">
                        <label for="semnatar1_functie">Funcția primului semnatar:</label>
                        <input type="text" id="semnatar1_functie" name="semnatar1_functie" placeholder="ex: Manager" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="semnatar2_nume">Numele celui de-al doilea semnatar:</label>
                        <input type="text" id="semnatar2_nume" name="semnatar2_nume" placeholder="ex: Ionescu Maria">
                    </div>
                    <div class="form-group">
                        <label for="semnatar2_functie">Funcția celui de-al doilea semnatar:</label>
                        <input type="text" id="semnatar2_functie" name="semnatar2_functie" placeholder="ex: Contabil">
                    </div>
                </div>
                
                <button type="submit" class="btn">Generează Procesul Verbal PDF</button>
            </form>
        </div>
    </div>
    
    <script>
        // Set current date and time
        document.addEventListener('DOMContentLoaded', function() {
            const now = new Date();
            const date = now.toISOString().split('T')[0];
            const time = now.toTimeString().split(' ')[0].substring(0, 5);
            
            document.getElementById('data').value = date;
            document.getElementById('ora').value = time;
        });
    </script>
</body>
</html>
